/*	BASIC INTERRUPT VECTOR TABLE FOR STM8 devices
 *	Copyright (c) 2009 STMicroelectronics
 */


#include "stm8l10x_it.h"

extern void @near _stext(); /* startup routine */

void @near (* const _vectab[])() = {

                                       (void @near (*)())0x8200,
                                       _stext,		/* Reset */

                                       (void @near (*)())0x8200,																			 
                                       TRAP_IRQHandler,			/* TRAP - Software interrupt  [for GP products]*/
																			 /*TIM4_UPD_OVF_IRQHandler,*/ /* Timer4 Update/Overflow interrupt [for QST products]*/

                                       (void @near (*)())0x8200,
                                       NonHandledInterrupt,			/* irq0 - Reserved */

                                       (void @near (*)())0x8200,
                                       FLASH_IRQHandler,			/* irq1 - FLASH interrupt */

                                       (void @near (*)())0x8200,
                                       NonHandledInterrupt,			/* irq2 - Reserved */

                                       (void @near (*)())0x8200,
                                       NonHandledInterrupt,			/* irq3 - Reserved */

                                       (void @near (*)())0x8200,
                                       AWU_IRQHandler,			/* irq4 - Auto Wake Up interrupt */

                                       (void @near (*)())0x8200,
                                       NonHandledInterrupt,      /* irq5 - Reserved */

                                       (void @near (*)())0x8200,
                                       EXTIB_IRQHandler,      /* irq6 - External IT PORTB interrupt */

                                       (void @near (*)())0x8200,
                                       EXTID_IRQHandler,			/* irq7 - External IT PORTD interrupt */

                                       (void @near (*)())0x8200,
                                       EXTI0_IRQHandler,			/* irq8 - External IT PIN0 interrupt */

                                       (void @near (*)())0x8200,
                                       EXTI1_IRQHandler,			/* irq9 - External IT PIN1 interrupt */

                                       (void @near (*)())0x8200,
                                       EXTI2_IRQHandler,			/* irq10 - External IT PIN2 interrupt */

                                       (void @near (*)())0x8200,
                                       EXTI3_IRQHandler,		  /* irq11 - External IT PIN3 interrupt */

                                       (void @near (*)())0x8200,
                                       EXTI4_IRQHandler,      /* irq12 - External IT PIN4 interrupt */

                                       (void @near (*)())0x8200,
                                       EXTI5_IRQHandler,      /* irq13 - External IT PIN5 interrupt */

                                       (void @near (*)())0x8200,
                                       EXTI6_IRQHandler,      /* irq14 - External IT PIN6 interrupt */

                                       (void @near (*)())0x8200,
                                       EXTI7_IRQHandler,      /* irq15 - External IT PIN7 interrupt */

                                       (void @near (*)())0x8200,
                                       NonHandledInterrupt,      /* irq16 - Reserved */

                                       (void @near (*)())0x8200,
                                       NonHandledInterrupt,      /* irq17 - Reserved */

                                       (void @near (*)())0x8200,
                                       COMP_IRQHandler,      /* irq18 - Comparator interrupt */

                                       (void @near (*)())0x8200,
                                       TIM2_UPD_OVF_TRG_BRK_IRQHandler,      /* irq19 - Timer2 Update/Overflow/Trigger/Break interrupt */

                                       (void @near (*)())0x8200,
                                       TIM2_CAP_IRQHandler,      /* irq20 - Timer2 Capture/Compare interrupt */

                                       (void @near (*)())0x8200,
                                       TIM3_UPD_OVF_TRG_BRK_IRQHandler,      /* irq21 - Timer3 Update/Overflow/Trigger/Break interrupt */

                                       (void @near (*)())0x8200,
                                       TIM3_CAP_IRQHandler,			/* irq22 - Timer3 Capture/Compare interrupt */

                                       (void @near (*)())0x8200,
                                       NonHandledInterrupt,      /* irq23 - Reserved */

                                       (void @near (*)())0x8200,
                                       NonHandledInterrupt,      /* irq24 - Reserved */

                                       (void @near (*)())0x8200,
                                       TIM4_UPD_OVF_IRQHandler,      /* irq25 - Timer4 Update/Overflow interrupt */

                                       (void @near (*)())0x8200,
                                       SPI_IRQHandler,      /* irq26 - SPI interrupt */

                                       (void @near (*)())0x8200,
                                       USART_TX_IRQHandler,      /* irq27 - USART TX interrupt */

                                       (void @near (*)())0x8200,
                                       USART_RX_IRQHandler,      /* irq28 - USART RX interrupt */

                                       (void @near (*)())0x8200,
                                       I2C_IRQHandler,      /* irq29 - I2C interrupt */

                                   };

/******************* (C) COPYRIGHT 2009 STMicroelectronics *****END OF FILE****/
